#include "CameraCBuffer.hlsli"
#include "SamplerStates.hlsli"

Texture2D<float2> VelocityMap : register(t0);

#include "MotionBlur.hlsli"

struct PSInput {
	float4 PositionViewportS : SV_Position;
	float2 TexCoords : TEXCOORD0;
};

float4 main(PSInput input) : SV_TARGET
{
	float2 velocity = VelocityMap.SampleLevel(LinearSampler, input.TexCoords, 0);

	// Visualize velocity as values in the range [0, 1] (0 becomes 0.5)
	velocity *= 100;
	velocity += float2(0.5, 0.5);
	float4 color = float4(velocity, 0.5, 1);

	return color;
}